/*
 * Decompiled with CFR 0.152.
 */
package common.core.objects;

import common.exceptions.DateOfBirthValidationError;
import common.exceptions.TestFailException;
import java.util.Calendar;
import java.util.Date;

public class Person {
    public static final boolean CLUSTER_SUPPORT = true;
    public static final int ADULT_AGE = 33;
    private static final String revision = "$Revision: 80 $";
    private static final String author = "$Author: sebcoope $";
    private String surname;
    private String forename1;
    private String forename2;
    private String forename3;
    private String forename4;
    private String forename5;
    private Date dateOfBirth;

    public void testLeo() {
    }

    public Person(String string, String string2, String string3, String string4, String string5, String string6, Date date) {
        this.surname = string;
        this.forename1 = string2;
        this.forename2 = string3;
        this.forename3 = string4;
        this.forename4 = string5;
        this.forename5 = string6;
        this.setDateOfBirth(date);
    }

    public Date getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(Date date) {
        if (date.after(new Date(System.currentTimeMillis()))) {
            throw new DateOfBirthValidationError();
        }
        this.dateOfBirth = date;
    }

    public int getAgeInYears() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.dateOfBirth);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTimeInMillis(System.currentTimeMillis());
        int n = calendar2.get(1) - calendar.get(1);
        int n2 = calendar2.get(2);
        int n3 = calendar.get(2);
        int n4 = calendar2.get(5);
        int n5 = calendar.get(5);
        if (n2 < n3) {
            --n;
        } else if (n2 == n3 && n4 < n5) {
            --n;
        }
        return n;
    }

    private Person() {
    }

    private boolean isAdult() {
        return this.getAgeInYears() >= 33;
    }

    private void testYears() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        int n = 18;
        calendar.add(1, -n);
        this.setDateOfBirth(calendar.getTime());
        calendar.add(5, 1);
        this.setDateOfBirth(calendar.getTime());
        if (this.getAgeInYears() != n - 1) {
            throw new TestFailException("Failed Age Test: Birthday is Tommorow");
        }
        calendar.add(5, -2);
        this.setDateOfBirth(calendar.getTime());
        if (this.getAgeInYears() != n) {
            throw new TestFailException("Failed Age Test: Birthday is Yesterday");
        }
    }

    private void testAdult() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        calendar.add(1, -33);
        if (!this.isAdult()) {
            throw new TestFailException("Failed Adult Test: Birthday Today");
        }
    }

    public static void testClass() {
        Person person = new Person();
        person.testYears();
        person.testAdult();
        System.out.println("Person: Test Completed");
    }

    public static void main(String[] stringArray) {
        Person.testClass();
    }
}

