dfbdfb
/**
 * 
 */
package common.core.objects;


import java.util.Calendar;
import java.util.Date;

import common.exceptions.DateOfBirthValidationError;
import common.exceptions.TestFailException;

/**
 * @author Seb
 * 
 */



public class Person {
      public static final boolean CLUSTER_SUPPORT=true;
	public static final int ADULT_AGE =33;
	private static final String revision="$Revision: 85 $";
	private static final String author="$Author: sebcoope $";
	/**
	 * @param surname
	 * @param forename1
	 * @param forename2
	 * @param forename3
	 * @param forename4
	 * @param forename5
	 * @param dateOfBirth
	 */
	public void testLeo(){
		
	}
        string abc;
	public Person(String surname, String forename1, String forename2,
			String forename3, String forename4, String forename5,
			Date dateOfBirth) {
		this.surname = surname;
		this.forename1 = forename1;
		this.forename2 = forename2;
		this.forename3 = forename3;
		this.forename4 = forename4;
		this.forename5 = forename5;
		this.setDateOfBirth(dateOfBirth);
	}

	private String surname;
	private String forename1;
	private String forename2;
	private String forename3;
	private String forename4;
	private String forename5;
	private Date dateOfBirth;

	public Date getDateOfBirth() {
		return dateOfBirth;
	}

	public void setDateOfBirth(Date dateOfBirth) {
		if (dateOfBirth.after(new Date(System.currentTimeMillis()))) {
			throw new DateOfBirthValidationError();
		}
		this.dateOfBirth = dateOfBirth;
	}

	public int getAgeInYears() {
		Calendar dobCal = Calendar.getInstance();
		dobCal.setTime(dateOfBirth);
		Calendar nowCal = Calendar.getInstance();
		nowCal.setTimeInMillis(System.currentTimeMillis());
		int years = nowCal.get(Calendar.YEAR) - dobCal.get(Calendar.YEAR);
		int nowMonth = nowCal.get(Calendar.MONTH);
		int dobMonth = dobCal.get(Calendar.MONTH);
		int nowDay = nowCal.get(Calendar.DAY_OF_MONTH);
		int dobDay = dobCal.get(Calendar.DAY_OF_MONTH);
		if (nowMonth<dobMonth) {
			years--; // take 1 of years, before birthday
		} else {
			if (nowMonth == dobMonth) {
				if (nowDay<dobDay) {
					years--; // same month but still before birthday, take 1 of
				}
			}
		}
		return (years);
	}

	/**
	 * Private default constructor, used for testing only
	 */
	private Person() {

	}

	private boolean isAdult() {
		return (getAgeInYears() >= ADULT_AGE);
	}

	
	private void testYears() {
		Calendar dobCal = Calendar.getInstance(); // set up current time
		dobCal.setTimeInMillis(System.currentTimeMillis()); // set up time
		int testAge=18;
		dobCal.add(Calendar.YEAR,-testAge);
		setDateOfBirth(dobCal.getTime());

		dobCal.add(Calendar.DAY_OF_MONTH, 1); // move to tommorow
		setDateOfBirth(dobCal.getTime());
		if (getAgeInYears()!=testAge-1) {
			throw new TestFailException("Failed Age Test: Birthday is Tommorow");
		}
		dobCal.add(Calendar.DAY_OF_MONTH, -2); // move to yesterday
		setDateOfBirth(dobCal.getTime());
		if (getAgeInYears()!=testAge) {
			throw new TestFailException("Failed Age Test: Birthday is Yesterday");
		}						
	}
	
	private void testAdult() {
		Calendar dobCal = Calendar.getInstance(); // set up current time
		dobCal.setTimeInMillis(System.currentTimeMillis()); // set up time
		dobCal.add(Calendar.YEAR,-Person.ADULT_AGE);
		if (!isAdult()) {
			throw new TestFailException("Failed Adult Test: Birthday Today");
		}
		return;
		
	}

	public static void testClass() {
		Person testInstance = new Person();
		testInstance.testYears();
		testInstance.testAdult();
		System.out.println("Person: Test Completed");
	}

	public static void main(String argvs[]) {
		Person.testClass();

	}
	//changes
}
