package com.logger;

import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;

import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.util.StringUtils;

public class JavacFileLogger implements BuildLogger {

  protected PrintStream out;

  protected PrintStream err;

  protected static final String eol = StringUtils.LINE_SEP;


  private boolean compiling = false;

  public void buildStarted(BuildEvent event) {
	
  }

  public void buildFinished(BuildEvent event) {
      out.println("");
      out.println("Java compilation errors..");
      for (String filename : compileErrors) {
        out.print(filename);
        out.print(eol);
      }

  }

  public void targetStarted(BuildEvent event) {
  }

  public void targetFinished(BuildEvent event) {
  }

  public void taskStarted(BuildEvent event) {
    if (event.getTask().getTaskName().equals("javac")) {
      compiling = true;
    }

  }

  private Set<String> compileErrors = new HashSet<String>();

  public void taskFinished(BuildEvent event) {
  }

  public void messageLogged(BuildEvent event) {
    int priority = event.getPriority();
    if (priority <= outputLevel) {
       out.println(event.getMessage());
    }
    if (compiling) {
      String mess=event.getMessage();
      if (mess.contains(".java:")) {
        compileErrors.add("File :"+mess.substring(0,mess.indexOf(".java:")));
        compileErrors.add("Problem :"+event.getMessage());
      }
    }
  }

  public void setErrorPrintStream(PrintStream err) {
    this.err = err;
  }

  public void setEmacsMode(boolean emacsMode) {
  }

  public void setOutputPrintStream(PrintStream output) {
    this.out = output;
  }

  private int outputLevel=0;
  public void setMessageOutputLevel(int level) {
     outputLevel=org.apache.tools.ant.types.LogLevel.INFO.getLevel();
  }

}