define([ "Renderable","Util" ], function(Renderable,Util) {
	'use strict';
	var constructor = function Person(surname) {		
		Renderable.apply(this, arguments);			// constructor for superclass
		var sname=surname;		// private
		var dob=null;			// private
		this.getSurname =function() {	// privilidged
			return(sname);
		}
		this.setSurname = function(surname) {
			sname=surname;
		}	
		this.onRender=function(id) {
			var div = document.getElementById(id);
			div.innerHTML=surname;		
		}
		this.setDOB=function(day,month,year) {
			if (Util.getType(day)!='number') {
				throw new Error("Day must be number");
			}
			if (Util.getType(month)!='number') {
				throw new Error("Monst must be number");
			}
			if (Util.getType(year)!='number') {
				throw new Error("Year must be number");
			}
			this.dob=new Date(year,month,day,0,0,0,0);
		}	
	};
	return (constructor);
});
